﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaIntegration.Mdws2
{
    public static class VistaConverters
    {

        public static string VistAToInternalFormat(this DateTime dateTime)
        {
            string year = (dateTime.Year - 1700).ToString("000");
            string otherInfo = dateTime.ToString("MMdd.HHmmss").TrimEnd('0');
            otherInfo = otherInfo.TrimEnd('.');
            return year + otherInfo;
        }


        public static DateTime VistAToDateTime(this string value)
        {
            string year = value.Substring(0, 3);
            string mouth = value.Substring(3, 2);
            string day = value.Substring(5, 2);
            string hour = value.Length >= 10 ?
                value.Substring(8, 2) :
                "0";
            string minute = value.Length >= 12 ?
                value.Substring(10, 2) :
                "0";
            string seconds = value.Length >= 14 ?
                value.Substring(12, 2) :
                "0";

            int y = int.Parse(year) + 1700;
            int m = int.Parse(mouth);
            if (m == 0)
                m = 1;
            int d = int.Parse(day);
            if (d == 0)
                d = 1;
            int h = int.Parse(hour);
            int mm = int.Parse(minute);
            int s = int.Parse(seconds);

            DateTime result = new DateTime(y, m, d, h, mm, s);
            return result;
        }

        public static bool VistAToBool(this string value)
        {
            return value != "0";
        }

        public static string VistAVariablePointerValue(this string value)
        {
            int index = value.IndexOf(';');
            return value.Substring(0, index);
        }

        public static string VistAVariablePointerType(this string value)
        {
            int index = value.IndexOf(';');
            return value.Substring(index + 1);
        }
    }
}
